﻿--***************************************************************************
--*
--* Alter Table Voxco_Project
--*
--***************************************************************************
alter TABLE [dbo].[MonitoringCfgQuestionsThatCount] 
   alter column [QuestionAlias] [varchar] (32)  NOT NULL --PK
GO
alter TABLE [dbo].[ImportedFields] 
   alter column [IFQuestion] [nvarchar] (32)  NULL 
GO
alter TABLE [dbo].[Note] 
   alter column [NotQuestion] [nvarchar] (32)  NOT NULL 
GO
alter TABLE [dbo].[Response] 
   alter column [RpsQuestion] [nvarchar] (32)  NOT NULL --PK
GO
alter TABLE [dbo].[ResponseModifLog] 
   alter column [Question] [nvarchar] (32)  NOT NULL 
GO

--***************************************************************************
--*
--* Drop & Create View Voxco_Project
--*
--***************************************************************************
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Question]') and OBJECTPROPERTY(id, N'IsView') = 1)
  DROP VIEW [dbo].[Question]
GO
create view dbo.Question as select * from #VoxcoSystemDatabaseName#.dbo.Question
GO

IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[QuestionCode]') and OBJECTPROPERTY(id, N'IsView') = 1)
  DROP VIEW [dbo].[QuestionCode]
GO
create view dbo.QuestionCode as select * from #VoxcoSystemDatabaseName#.dbo.QuestionCode
GO

--***************************************************************************
--*
--* Drop & Create Stored Procedure Voxco_Project
--*
--***************************************************************************
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_batchaddrespondentresponse]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_batchaddrespondentresponse]
GO
CREATE PROCEDURE [dbo].[Sp_batchaddrespondentresponse](
                @ProjectId   INT,
                @UserId      INT,
                @CollectMode INT,
                @RpsQuestion VARCHAR(32),
                @RpsMatrix   INT,
                @maxMention  INT,
                @RpsContent  NVARCHAR(100),
                @rpsType     INT)
AS
  -- BUT: Ajouter un code dans le premier espace vide sur une list de rpondent
  -- la list des rpondant se trouvant dans une table temporaire du nom 
  -- de #TargetRespondents
  --creer la liste des Updateables
  SELECT *
  INTO   #updateable_resp
  FROM   (SELECT   #targetrespondents.resrespondent,
                   Min(rpsmention) AS rpsmention
          FROM     #targetrespondents
                   INNER JOIN response
                     ON #targetrespondents.resrespondent = response.rpsrespondent
          WHERE    rpsmatrix = @RpsMatrix
                   AND rpsquestion = @RpsQuestion
                   AND rpscontent = ''
          GROUP BY #targetrespondents.resrespondent) resp;
  -- creer la liste des Insertables
  SELECT resrespondent,
         rpsmention + 1 AS rpsmention
  INTO   #insertable_resp
  FROM   (SELECT   #targetrespondents.resrespondent,
                   Max(rpsmention) AS rpsmention
          FROM     #targetrespondents
                   INNER JOIN response
                     ON #targetrespondents.resrespondent = response.rpsrespondent
          WHERE    rpsmatrix = @RpsMatrix
                   AND rpsquestion = @RpsQuestion
          GROUP BY #targetrespondents.resrespondent) resp
  WHERE  rpsmention < @maxMention
  -- DO the Update
  UPDATE response
  SET    rpscontent = @RpsContent
  FROM   response response
         INNER JOIN #updateable_resp target
           ON response.rpsrespondent = target.resrespondent
              AND response.rpsmention = target.rpsmention
  WHERE  response.rpsquestion = @RpsQuestion
         AND response.rpsmatrix = @RpsMatrix;
  -- DO The insert
  INSERT INTO response 
   (
   rpsrespondent,
   rpsquestion,
   rpsmatrix,
   rpsmention,
   rpscontent,
   rpsopened,
    rpstype,
   projectid,
   collectmode,
   modifiedby,
    modified
   )
  SELECT target.resrespondent AS rpsrespondent,
         @RpsQuestion         AS rpsquestion,
         @RpsMatrix           AS rpsmatrix,
         target.rpsmention,
         @RpsContent          AS rpscontent,
         ''                   AS rpsopened,
         @rpsType             AS rpstype,
         @projectId           AS projectid,
         @CollectMode         AS collectmode,
         @UserId              AS modifiedby,
         Getdate()            AS modified
  FROM   #insertable_resp AS target
  --Insert modif Log
  INSERT INTO responsemodiflog
             (respondent,
              question,
              matrix,
              mention,
              [Content],
              source,
              COMMENT,
              modifiedby,
              modified)
  SELECT target.resrespondent AS rpsrespondent,
         @RpsQuestion         AS rpsquestion,
         @RpsMatrix           AS rpsmatrix,
         target.rpsmention,
         @RpsContent          AS rpscontent,
         'OpenCodification'   AS source,
         'AddCode'            AS COMMENT,
         @UserId              AS modifiedby,
         Getdate()            AS modified
  FROM   #insertable_resp AS target
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_batchaddrespondentresponsevalidation]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_batchaddrespondentresponsevalidation]
GO
CREATE PROCEDURE [dbo].[Sp_batchaddrespondentresponsevalidation](
                @RpsQuestion VARCHAR(32),
                @RpsMatrix   INT,
                @maxMention  INT)
AS
  --BUT: Savoir si il est possible d'ajouter un code sur une list de r?pondent
  -- la list des r?pondant se trouvant dans une table temporaire du nom 
  -- de #TargetRespondents
  -- en retour: La list des r?pondent impossible a ajouter un code.
  -- Validation check ceux qui sont en d?passement de capacit?
  SELECT *
  INTO   #mention_overflow
  FROM   (SELECT   resrespondent,
                   Max(rpsmention) AS umax
          FROM     #targetrespondents targetresp
                   INNER JOIN response
                     ON targetresp.resrespondent = response.rpsrespondent
          WHERE    rpsmatrix = @RpsMatrix
                   AND rpsquestion = @RpsQuestion
          GROUP BY targetresp.resrespondent) resp
  WHERE  umax >= @maxMention
  -- maintenant on delete de la table #MENTION_OVERFLOW tout ceux 
  -- qui ont des mentions vide ( cherche la plus petite mention vide )
  DELETE FROM #mention_overflow
  WHERE       resrespondent IN (SELECT resrespondent
                                FROM   (SELECT   targetresp.resrespondent,
                                                 Min(rpsmention) AS imin
                                        FROM     #targetrespondents targetresp
                                                 INNER JOIN response
                                                   ON targetresp.resrespondent = response.rpsrespondent
                                        WHERE    response.rpsmatrix = @RpsMatrix
                                                 AND response.rpsquestion = @RpsQuestion
                                                 AND response.rpscontent = ''
                                        GROUP BY targetresp.resrespondent) resp)
  --return left over if any
  SELECT *
  FROM   #mention_overflow
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_importrandompin]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_importrandompin]
GO
CREATE PROCEDURE [dbo].[Sp_importrandompin](
                @ProjectId     INT,
                @userId        INT,
                @resRespondent VARCHAR(10),
                @mask          VARCHAR(20),
                @pinQuestion   VARCHAR(32))
AS
  DECLARE  @loopCount INT
  SET @loopCount = 0
  DECLARE  @pin VARCHAR(20)
  SET @pin = ''
  WHILE 1 = 1
    BEGIN
      EXEC Sp_generaterandompin
        @mask ,
        @pin OUTPUT
      DECLARE  @pinExists INT
      SELECT @pinExists = Count(rsppin)
      FROM   respondentpin
      WHERE  rsppin = @pin
      IF @pinExists = 0
        BEGIN
          UPDATE respondentpin
          SET    rsppin = @pin
          WHERE  rsprespondent = @resRespondent
          IF @@ROWCOUNT = 0
            INSERT INTO respondentpin
                       (rsprespondent,
                        rsppin,
                        projectid,
                        modifiedby,
                        modified)
            VALUES     (@resRespondent,
                        @pin,
                        @ProjectId,
                        @userId,
                        Getutcdate())
          BREAK;
        END
      SET @loopCount = @loopCount + 1
      IF @loopCount = 100
        BEGIN
          DECLARE  @errormsg VARCHAR(256)
          SET @errormsg = 'VOXCOERROR_1001 Unable to generate PIN with mask ' + @mask
          RAISERROR (@errormsg,16,1)
          RETURN
        END
    END
  IF @pinQuestion IS NOT NULL
     AND @pinQuestion <> ''
    BEGIN
      IF @pinQuestion = '$N'
        BEGIN
          UPDATE respondent
          SET    resphone = @pin
          WHERE  resrespondent = @resrespondent
        END
      ELSE
        BEGIN
          UPDATE response
          SET    rpscontent = @pin
          WHERE  rpsquestion = @pinQuestion
                 AND rpsmention = 1
                 AND rpsmatrix = 1
                 AND rpstype = 0
                 AND rpsrespondent = @resrespondent
          IF @@ROWCOUNT = 0
            INSERT INTO response
                       (rpsrespondent,
                        rpsquestion,
                        rpsmatrix,
                        rpsmention,
                        rpscontent,
                        rpsopened,
                        rpstype)
            VALUES     (@resrespondent,
                        @pinQuestion,
                        1,
                        1,
                        @pin,
                        NULL,
                        0)
        END
    END
GO

IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_updaterespondentnote]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	DROP PROCEDURE [dbo].[Sp_updaterespondentnote]
GO
CREATE PROCEDURE [dbo].[Sp_updaterespondentnote]
                @projectId     INT,
                @UserId        INT,
                @collectMode   INT,
                @NotRespondent VARCHAR(10),
                @NotDateTime   DATETIME,
                @NotInterv     VARCHAR(10),
                @NotQuestion   VARCHAR(32),
                @NotMatrix     INT,
                @NotNote       NVARCHAR(500)
AS
  UPDATE note
  SET    projectid = @ProjectId,
         collectmode = @CollectMode,
         modifiedby = @UserId,
         modified = Getutcdate(),
         notquestion = @NotQuestion,
         notmatrix = @NotMatrix,
         notnote = @NotNote
  WHERE  notrespondent = @NotRespondent
         AND notdatetime = @NotDateTime
         AND notinterv = @NotInterv
  IF @@ROWCOUNT = 0
    BEGIN
      INSERT INTO note
                 (projectid,
                  collectmode,
                  modifiedby,
                  modified,
                  notrespondent,
                  notdatetime,
                  notinterv,
                  notquestion,
                  notmatrix,
                  notnote)
      VALUES     (@ProjectId,
                  @CollectMode,
                  @UserId,
                  Getutcdate(),
                  @NotRespondent,
                  @NotDateTime,
                  @NotInterv,
                  @NotQuestion,
                  @NotMatrix,
                  @NotNote)
    END
GO

IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[Sp_UpdateRespondentResponseCode]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
  DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponseCode]
GO
CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponseCode]
 @ProjectId     INT,
 @UserId        INT,
 @CollectMode   INT,
 @RpsRespondent VARCHAR(10),
 @RpsQuestion   VARCHAR(32),
 @RpsMatrix     BIGINT,
 @RpsMention    INT,
 @RpsContent    NVARCHAR(100),
 @rpsType       INT,
 @CallId        INT,
 @Source        nvarchar(max)
 
AS
  UPDATE Response
  SET    ProjectId = @ProjectId,
         CollectMode = CASE WHEN @CollectMode < 0 THEN collectmode ELSE @CollectMode END,
         modifiedby = @UserId,
         modified = Getutcdate(),
         RpsContent = @RpsContent,
         CallId = @CallId,
         [Source] = @Source
  WHERE  RpsRespondent = @RpsRespondent
         AND RpsQuestion = @RpsQuestion
         AND RpsMatrix = @RpsMatrix
         AND RpsMention = @RpsMention
         AND RpsType = @RpsType
  IF @@ROWCOUNT = 0
  BEGIN
 INSERT INTO Response
    (RpsRespondent,
     ProjectId,
     CollectMode,
     modifiedby,
     modified,
     RpsQuestion,
     RpsMatrix,
     RpsMention,
     RpsContent,
     RpsOpened,
     RpsType,
     CallId,
     [Source])
 VALUES    (@RpsRespondent,
     @ProjectId,
     @CollectMode,
     @UserId,
     Getutcdate(),
     @RpsQuestion,
     @RpsMatrix,
     @RpsMention,
     @RpsContent,
     '',
     @rpsType,
     @CallId,
     @Source)
  END
GO
